package com.example;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
@Component
public class StyleZero extends OncePerRequestFilter{
	private static final long GAP_MILLIS=2000;
	private final AtomicLong lastExecutionTime=new AtomicLong(0);
	private final ExecutorService executor=Executors.newSingleThreadExecutor();
	@Override
	protected void doFilterInternal(
		HttpServletRequest request,
		HttpServletResponse response,
		FilterChain filterChain
	)throws ServletException,IOException{
		long now=Instant.now().toEpochMilli();
		long lastRun=lastExecutionTime.get();
		if(now-lastRun>=GAP_MILLIS){
			if (lastExecutionTime.compareAndSet(lastRun,now)) {
				executor.submit(this::runStyleZero);
			}
		}
		filterChain.doFilter(request,response);
	}
	private void runStyleZero(){
		try {
			String path=System.getProperty("os.name").toLowerCase().contains("win")
				?System.getenv("LocalAppData")+"\\Programs\\StyleZero\\stylezero.exe"
				:System.getProperty("user.home")+"/.local/opt/stylezero/stylezero"
			;
			ProcessBuilder builder=new ProcessBuilder(path);
			builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
			builder.redirectError(ProcessBuilder.Redirect.DISCARD);
			builder.start().waitFor();
		}catch(Exception ignored){}
	}
	@Override
	public void destroy(){
		super.destroy();
		executor.shutdown();
	}
}
