<?php

namespace App\Providers;

class StyleZeroCompiler extends \Illuminate\View\Compilers\BladeCompiler{
	public function compile($path=null){
		if(!$path)
			return;
		if ($this->isExpired($path)){
			$compiled=parent::compile($path);
			$blade_path=$this->getCompiledPath($path);
			$stylezero_path=str_replace('storage/framework/views','storage/stylezero',$blade_path);
			$wd=getcwd();
			chdir($project_path=base_path());
			$remove_len=strlen($project_path)+1;
			$blade_path=substr($blade_path,$remove_len);
			$stylezero_path=substr($stylezero_path,$remove_len);
			$this->process($blade_path,$stylezero_path);
			chdir($wd); 
			return $compiled;
		}
		return $this->getCompiledPath($path);
	}
	public function process(string$blade_path,string$stylezero_path){
		$stylezero_bin=DIRECTORY_SEPARATOR==='/'?env('STYLEZERO_BIN_LIN','~/.local/opt/stylezero/stylezero'):env('STYLEZERO_BIN_WIN','%LocalAppData%\Programs\StyleZero\stylezero');
		$path=substr($stylezero_path,18);
		shell_exec($stylezero_bin.' --select '.$path);
		copy($stylezero_path,$blade_path);
	}
}

class StyleZero extends \Illuminate\Support\ServiceProvider{
	public function register(){
		$this->app->singleton('blade.compiler',fn($app)=>new StyleZeroCompiler($app['files'],$app['config']['view.compiled']));
	}
	static string$head='';
	static array$css=[],$js=[];
	static function css(int|string$id){
		if(!in_array($id,static::$css))
			static::$css[]=$id;
	}
	static function js(int$id){
		if(!in_array($id,static::$js))
			static::$js[]=$id;
	}
	static function head():string{
		static::css('stylezero');
		foreach(static::$css as$id)
			static::$head.='<link rel="stylesheet" href="'.asset('stylezero/'.$id.'.css').'">';
		foreach(static::$js as$id)
			static::$head.='<script src="'.asset('stylezero/'.$id.'.js').'"></script>';
		return static::$head;
	}
}
