<?php
namespace App\Http\Middleware;

use Closure;

class StyleZero{
	static string$bin;
	static string$head='';
	static array$css=[],$js=[];
	static bool$compile;
	static function bin():string{
		if(!is_callable('shell_exec'))
			return'';
		if(is_numeric(str_replace('.','',shell_exec(static::$bin.' --version'))))
			return static::$bin;
		$file=DIRECTORY_SEPARATOR==='/'?'~/.local/opt/stylezero/stylezero':'%LocalAppData%\Programs\StyleZero\stylezero';
		if(is_numeric(str_replace('.','',shell_exec($file.' --version'))))
			return$file;
		return'';
	}
	static function css(int|string$id){
		if(!in_array($id,static::$css))
			static::$css[]=$id;
	}
	static function js(int$id){
		if(!in_array($id,static::$js))
			static::$js[]=$id;
	}
	static function head():string{
		static::css('stylezero');
		foreach(static::$css as$id)
			static::$head.='<link rel="stylesheet" href="'.asset('stylezero/'.$id.'.css').'">';
		foreach(static::$js as$id)
			static::$head.='<script src="'.asset('stylezero/'.$id.'.js').'"></script>';
		return static::$head;
	}
	public function handle($request,Closure$next){
		if(static::$compile&&($time=time())>(int)@file_get_contents($file='.stylezero.time')+1){
			@file_put_contents($file,$time);
			if($bin=static::bin())
				shell_exec((getcwd()===public_path()?'cd .. && ':'').$bin);
			else
				StyleZero::$head.="<script>setTimeout(()=>document.body.insertAdjacentHTML('afterend','<div style=\"position:fixed;width:400px;max-width:calc(100vw - 70px);top:20px;right:20px;padding:15px;border-radius:4px;background:indianred;color:white;font-family:sans-serif;font-size:x-small;font-weight:bold\">StyleZero cannot run automatically.<br><br>Instead run stylezero via terminal in watch mode:<br>stylezero --watch<br><br>To remove this message, create or set the env variabe STYLEZERO_AUTOCOMPILE to false in the .env file:<br>STYLEZERO_AUTOCOMPILE=false</div>'),100)</script>";
		}
		return $next($request);
	}
}

StyleZero::$compile=app()->isLocal()&&(env('STYLEZERO_AUTOCOMPILE')!==false);
StyleZero::$bin=env('STYLEZERO_BIN','stylezero');
